﻿// Applicable license: Code Project Open License (CPOL) 1.02
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Reflection;
using System.Text;
using System.Drawing;
using System.Drawing.Imaging;
using ParadoxReader;


////////////////////////////////////////////////////////////////////////////////
//  jeroen van dael 20241130 Modifications in file Db.cs:
//
//  Modified scope of FieldTypes in class ParadoxFile from internal to public.
//  Modified scope of class FieldInfo to get this info available outside the class.
//  Inhibited negative stringLength in GetString().
//  Redesigned GetStringFromMemo(..) to let it return a byte[] array of eleven bytes.
//  Modified the constructor of class ParadoxTable to handle files in a more general way.
//
//  Added LoggerClass.cs to enable easy logging to a logfile for those who don't like black commandline screens.
//  This class Logger is originally a GUI based tool from www.shayanderson.com, which is gone in the meantime.
//  All GUI related elements are commented out for this commandline application but could easily be restored for GUI applications.
//
//////////////////////////////////////////////////////////////////////////////

namespace ParadoxTest
{
    partial class Program
    {
        static void Main(string[] args)
        {
            string dbFile = string.Empty;
            if (args.Length == 0)
            {    
                Console.WriteLine("Intended use e.g.: ParadoxText gdpprs.db");
                return;
            }
            else
                dbFile = args[0];
//          string dbPath = Assembly.GetEntryAssembly().Location;
            string dbPath = AppDomain.CurrentDomain.BaseDirectory;
//          var dbPath = @"D:\C#\JvD\C#_ParadoxTestData\";
//          var dbFile = "gdpprs.db";
//          var dbFile = "gdpplt.db";
//          var dbFile = "album.DB";
//          var dbFile = "biolife.db";
 //         var dbFile = "cars.db";
//          var dbFile = "COUNTRIES.db";
//          var dbFile = "films.db";
            var mbFile = dbFile.ToLower().Replace(".d", ".m");              // "*.mb";
            string[] strTableNameBody = dbFile.ToString().Split('.');
            var table = new ParadoxTable(dbPath, strTableNameBody[0]);       //"*.db");

            if (dbPath[dbPath.Length - 1] != '\\')
                dbPath += "\\";
            string strMbFilePathName = dbPath + mbFile;

            InitiateLogclass("Log messages for ParadoxTest activated");
            Logger.log("ParadoxTest program started with " + dbFile.ToString());
            Logger.log(" ");
            Logger.log("sequential read all records from start");
            Logger.log(" ");

//          Console.WriteLine("Test 1: sequential read first 10 records from start");
            Console.WriteLine("Test 1: sequential read all records from start");
            Console.WriteLine("==========================================================");
            var myParadoxFile = new ParadoxFile(dbPath + dbFile);
            var recIndex = 1;
            Type sType = null;
            foreach (var rec in table.Enumerate())                  // it's a pitty that myParadoxFile doesn't contain the tables!
            {
                int iEventCatched = 0;
                int iMBBlockType = -1;                             // type iMBBlockType: 2,3
                string strMemoBlob = string.Empty;
                byte[] bBlob = null;
                int iLenS2 = 0, iLenS2Ori = 0;
                Console.WriteLine("Record #{0}", recIndex);
                for (int i = 0; i < myParadoxFile.FieldCount; i++)  // or: for (int i=0; i<table.FieldCount; i++)
                {
                    //if ( recIndex == 1 && i == 28)
                    //    iEventCatched = 1;

                    string strMsg = string.Empty;
                    strMemoBlob = string.Empty;

//                  string s1 = table.FieldNames[i].ToString();
                    string s1 = myParadoxFile.FieldNames[i].ToString();
                    string fldType = myParadoxFile.FieldTypes[i].fType.ToString();
                    string strS2 = string.Empty, strHxS2 = string.Empty, strS2FromArray = string.Empty;
                    var S2_11byte = rec.DataValues.GetValue(i);
                    if (S2_11byte == null || S2_11byte.Equals(null) == true || S2_11byte.ToString() == "System.DBNull" || S2_11byte.ToString() == string.Empty)
                    {
//                      continue;
                    }
                    else
                    {
                        if (fldType == "Graphic" /*|| fldType == "OLE"*/)  // Randy Beck: $10  "G"  Graphic BLOb // $0D  "B"  Binary Large Object 
                        {
                            strHxS2 = string.Empty;
                            iLenS2 = 0;
                            bBlob = ProcessBlobType((byte[])S2_11byte, strMbFilePathName, recIndex, s1, out iMBBlockType);
                            // get the length for logging:
                            iLenS2 = Math.Min(25, bBlob.Length);
                            strHxS2 = BitConverter.ToString((byte[])bBlob, 0, iLenS2);
                            strHxS2 = strHxS2.Replace('-', ' ');
                            strS2 = strHxS2;
                        }
                        else 
                        if ( fldType == "BLOb")  // Randy Beck: $10  "G"  Graphic BLOb // $0D  "B"  Binary Large Object 
                        {
                            strHxS2 = string.Empty;
                            iLenS2 = 0;
                            byte[] ByteBlock = null;
                            int iPntrArrayBlokNr = -1;
                            bBlob = ProcessBlobType((byte[])S2_11byte, strMbFilePathName, recIndex, s1, out iMBBlockType);                          

                            // get the length for logging:
                            iLenS2 = Math.Min(25, bBlob.Length);
                            strHxS2 = BitConverter.ToString((byte[])bBlob, 0, iLenS2);
                            strHxS2 = strHxS2.Replace('-', ' ');
                            strS2 = strHxS2;
                        }
                        else
                        if (fldType == "MemoBLOb") // Randy Beck: $0C  "M"  Memo BLOb 
                        {
                            byte[] ByteBlock = null;
                            int iPntrArrayBlokNr = -1;
                            iMBBlockType = DetectMBBlockType((byte[])S2_11byte, strMbFilePathName, out ByteBlock, out iPntrArrayBlokNr);
                            switch (iMBBlockType)
                            {
                                //////////////////////////////////////////////////////////////////////////
                                //          Block types:
                                //          00 - Header block
                                //          02 - Single blob block
                                //          03 - Suballocated block
                                //          04 - Free block
                                //////////////////////////////////////////////////////////////////////////
                                case 0:
                                    Logger.log("Sorry folks, Blob type 0 is not processed");
                                    break;
                                case 4:
                                    Logger.log("Sorry folks, Blob type 4 is not processed");
                                    break;
                                case 2:
                                    bBlob = ProcessType2Block(ByteBlock, (byte[])S2_11byte);
                                    strMemoBlob = ConvertAndFilterBytesToChars(bBlob, bBlob.Length);
                                    strMemoBlob = " BlobType " + iMBBlockType.ToString() + ", Blob Content: " + strMemoBlob;
                                    break;
                                case 3:
                                    bBlob = ProcessType3Block(ByteBlock, (byte[])S2_11byte, iPntrArrayBlokNr);
                                    strMemoBlob = ConvertAndFilterBytesToChars(bBlob, bBlob.Length);
                                    strMemoBlob = " BlobType " + iMBBlockType.ToString() + ", Blob Content: " + strMemoBlob;
                                    break;
                                default:
                                    // Not the type 2 or 3 we are looking for
                                    byte[] bTmpArr = ((byte[])S2_11byte);
                                    S2_11byte = RemoveZerosFromEnd(bTmpArr);
                                    strMemoBlob = "unable to proces Blob type: " + iMBBlockType.ToString(); //strS2;
                                    iMBBlockType = -1;
                                    break;
                            }                            

                            iLenS2Ori = ((byte[])S2_11byte).Length;
                            strS2 = BitConverter.ToString((byte[])S2_11byte, 0, iLenS2Ori);
                            strS2 = strS2.Replace('-', ' ');

                        }   // if (fldType == "MemoBLOb")
                    }   // else ...

                    // for better logfile viewing: take care that all s1 texts are filled out equally 
                    int iTabDist = 9;
                    string strFiller1 = BerekenSpatieFiller(fldType.Length, iTabDist);
                    iTabDist = 14;
                    string strFiller2 = BerekenSpatieFiller(table.FieldNames[i].Length, iTabDist);

                    // get length for logging:
                    iLenS2 = Math.Min(25, strS2.Length);
                    if ( iLenS2 > 0 )
                        strS2 = "(first " + iLenS2.ToString() + " bytes) " + strS2;

                    if (strS2.Length == 0 && S2_11byte.ToString().Length > 0)
                        strS2 = S2_11byte.ToString();

                    string strLine = "fldtype " + fldType + strFiller1 + " | " + s1 + strFiller2 + " | " + strS2;
                    Console.WriteLine("    {0} = {1}", table.FieldNames[i], rec.DataValues[i]);

                    strMsg = "fld# " + i.ToString("00") + " | " + strLine;
                    if (strMemoBlob.Length > 0)
                        strMsg += " | " + strMemoBlob;
                    Logger.log(strMsg);
                }
                recIndex++;
                Logger.log(" ");

            }   // foreach (var rec ...)

        }   // void Main(string[] args)



        // jvd 20240309
        public static void InitiateLogclass(string strMessage)      // non-gui version
        {
            //Logger.LogListView1 = LoglistView1;

            //// Set the view to show details. (Outcommented for use in non0form Commandline App!
            //LoglistView1.View = View.Details;
            //LoglistView1.Columns.Add("#", 30, HorizontalAlignment.Left);
            //LoglistView1.Columns.Add("Date", 65, HorizontalAlignment.Left);
            //LoglistView1.Columns.Add("Time", 45, HorizontalAlignment.Left);
            ////          LoglistView1.Columns.Add("Msg", -2, HorizontalAlignment.Left);
            //LoglistView1.Columns.Add("Msg", 450, HorizontalAlignment.Left);


            // initialize logger : 
            string strCurDir = Directory.GetCurrentDirectory() + "\\LogFile.txt";
            Logger.filePath = strCurDir;

            // clear log file content
            Logger.flush();

            Logger.log(strMessage);

            //LoglistView1.Invalidate();
            //LoglistView1.Refresh();
            //LoglistView1.Show();


        }   // private void InitiateLogclass()
    }   // class Program
}
