﻿// Applicable license: Code Project Open License (CPOL) 1.02
using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Text;
using System.ComponentModel;
using System.Threading;
using System.Drawing.Imaging;

namespace ParadoxTest
{
    partial class Program
    {

        // jvd 20241201
        private static string ConvertAndFilterBytesToChars(byte[] bytebuffer, int iLen = 25)
        {
            string strRet = string.Empty;
            iLen = Math.Min(iLen, bytebuffer.Length);
            //          for (int ix = 0; ix < bytebuffer.Length && ix < iLen; ix++)
            for (int ix = 0; ix < iLen; ix++)
            {
                char c = Convert.ToChar(bytebuffer[ix]);
                // wees voorzichtig met het filteren ivm web-content
                // be careful with filtering, should not disturb web-content:
                if (c != '\r' && c != '\n')
                {
                    if (c != 0)
                        strRet += c;
                    else
                        strRet += '.';
                }
                else
                {
//                  if (c == '\r' || c == '\n')
                    if (bytebuffer.Length < 20) // ???
                    {
                        if (strRet[strRet.Length - 1] != ',')
                            strRet += ',';
                    }
                    else
                        if (strRet[strRet.Length - 1] != ' ')
                            strRet += ' ';
                }
            }

            return strRet;
        }   // string ConvertAndFilterBytesToChars(..)

        // jvd 20250116
        private static int DetectMBBlockType(byte[] S2_11byte, string mbPathFile, out byte[] ByteBlock, out int iPntrArrayBlokNr)
        {
            int iMBBlockType = -1;
            ByteBlock = null;
            iPntrArrayBlokNr = -1;
            if (File.Exists(mbPathFile) == false)
                return iMBBlockType;

 //         string tmp = BitConverter.ToString(S2_11byte); // jvd for logging
            iPntrArrayBlokNr = S2_11byte[1];
            long lOffset1 = S2_11byte[3] + 256 * S2_11byte[2];      // big endian
            int iMemoLen = S2_11byte[5] + 256 * S2_11byte[6];       // little endian

            //// Read 1k bytes in memory:
            int iBlobLen = 4096;

            // Read 1k bytes in memory:
            ByteBlock = ReadFromMBFile(mbPathFile, lOffset1, iBlobLen);
            if (ByteBlock == null)
                return iMBBlockType;
            iMBBlockType = ByteBlock[0];

            return iMBBlockType;
        }   // int DetectBlockType(..)

        // jvd 20250116
        private static string BerekenSpatieFiller(int fldLength, int iTabDist)
        {
            string strFiller = string.Empty;
            if (fldLength < iTabDist)
                strFiller = new string(' ', iTabDist - fldLength);
            return strFiller;
        }   // static string BerekenSpatieFiller(..)

        // jvd 20250116
        private static byte[] RemoveZerosFromEnd(byte[] bTmpArr)
        {
            byte[] bRet = null;
            Array.Reverse(bTmpArr);
            int ix = 0;
            // neglect single non-null values between null-values:
            while (ix < bTmpArr.Length - 1 && (bTmpArr[ix] == 0 || bTmpArr[ix + 1] == 0))
                ix++;
            bRet = new byte[bTmpArr.Length - ix];
            int iz = 0;
            for (int iy = ix; iy < bTmpArr.Length; iy++)
            {
                bRet[iz] = bTmpArr[iy];
                iz++;
            }
            Array.Reverse(bRet);
            return bRet;
        }   // static byte[] RemoveZerosFromEnd(..)


        // jvd 20250118
        // copied from: https://stackoverflow.com/questions/5209506/how-can-i-know-what-image-format-i-get-from-a-stream
        // based on https://devblogs.microsoft.com/scripting/psimaging-part-1-test-image/
        public class ImageDetector
        {
            // https://en.wikipedia.org/wiki/List_of_file_signatures
            /* Bytes in c# have a range of 0 to 255 so each byte can be represented as
             * a two digit hex string. */
            private static readonly Dictionary<ImageFormat, string[][]> SignatureTable = new Dictionary<ImageFormat, string[][]>
            {
                {
                    ImageFormat.Jpeg,
                    new[]
                    {
                        new[] {"FF", "D8", "FF", "DB"},
                        new[] {"FF", "D8", "FF", "EE"},
                        new[] {"FF", "D8", "FF", "E0", "00", "10", "4A", "46", "49", "46", "00", "01"}
                    }
                },
                {
                    ImageFormat.Gif,
                    new[]
                    {
                        new [] { "47", "49", "46", "38", "37", "61" },
                        new [] { "47", "49", "46", "38", "39", "61" }
                    }
                },
                {
                    ImageFormat.Png,
                    new[]
                    {
                        new[] {"89", "50", "4E", "47", "0D", "0A", "1A", "0A"}
                    }
                },
                {
                    ImageFormat.Bmp,
                    new []
                    {
                        new[] { "42", "4D" }
                    }
                }
            };
        
            /// <summary>
            /// Takes a byte array and determines the image file type by
            /// comparing the first few bytes of the file to a list of known
            /// image file signatures.
            /// </summary>
            /// <param name="imageData">Byte array of the image data</param>
            /// <returns>ImageFormat corresponding to the image file format</returns>
            /// <exception cref="ArgumentException">Thrown if the image type can't be determined</exception>
            public static ImageFormat GetImageType(byte[] imageData)
            {
                foreach (KeyValuePair<ImageFormat, string[][]> signatureEntry in SignatureTable)
                {
                    foreach (string[] signature in signatureEntry.Value)
                    {
                        bool isMatch = true;
                        for (int i = 0; i < signature.Length; i++)
                        {
                            string signatureByte = signature[i];
                    
                            // ToString("X") gets the hex representation and pads it to always be length 2
                            string imageByte = imageData[i]
                                .ToString("X2");

                            if (signatureByte == imageByte)
                                continue;
                            isMatch = false;
                            break;
                        }

                        if (isMatch)
                        {
                            return signatureEntry.Key;
                        }
                    }
                }
            
                //throw new ArgumentException("The byte array did not match any known image file signatures.");
                return null;
            }   // ImageFormat GetImageType(
        }   // public class ImageDetector   
    }   // public partial Program

}   // namespace ParadoxReader